package com.ejie.aa94a.utils;

import java.io.PrintWriter;

import java.util.List;
import java.util.Locale;
import com.ejie.aa94a.constantes.Constantes;
import com.ejie.aa94a.model.calculo.Bobina;
import com.ejie.aa94a.model.calculo.Estiba;

/**
 * HelpperExcel encargado de ayudar a pintar el excel mediante HTML
 * 
 * @author GFI
 * 
 */
public class HelpperHtml {

	/**
	 * Constructor de Utilidades
	 */
	private HelpperHtml() {
	}

	public static void pintaBobinasSolucion(PrintWriter stb, String id,
			String anchura, String diametroext, String peso, String distancia,
			List<Bobina> bobinas) {
		stb.append("<table border='1' width='100%'>");
		stb.append("<thead>");
		stb.append("<th class=\"text-center\">" + id + "</th>");
		stb.append("<th class=\"text-center\">" + anchura + "</th>");
		stb.append("<th class=\"text-center\">" + diametroext + "</th>");
		stb.append("<th class=\"text-center\">" + peso + "</th>");
		stb.append("<th class=\"text-center\">" + distancia + "</th>");
		stb.append("</thead>");
		stb.append("<tbody>");
		for (int i = 0; i < bobinas.size(); i++) {
			stb.append("<tr>");
			stb.append("<td align='center'>"
					+ bobinas.get(i).getPosicion().getIdentificacion()
					+ "</td>");
			stb.append("<td align='center'>" + bobinas.get(i).getAnchura()
					+ "</td>");
			stb.append("<td align='center'>" + bobinas.get(i).getDiametroExt()
					+ "</td>");
			stb.append("<td align='center'>"
					+ Utilidades.format(bobinas.get(i).getPeso(),
							Constantes.NUM_DECIMALES_PESO) + "</td>");
			stb.append("<td align='center'>"
					+ bobinas.get(i).getPosicion().getDistancia() + "</td>");
			stb.append("</tr>");
		}
		stb.append("</tbody>");
		stb.append("</table>");
	}

	public static void pintaSaltoDeLinea(PrintWriter stb) {
		stb.append("<tr><td colspan='5'></td></tr>");
	}

	public static void pintaBobinas(PrintWriter stb, String anchura,
			String diametroext, String peso, List<Bobina> bobinas) {
		stb.append("<table  border=1>");
		stb.append("<thead>");
		stb.append("<tr>");
		stb.append("<th class=\"text-center\">" + anchura + "</th>");
		stb.append("<th class=\"text-center\">" + diametroext + "</th>");
		stb.append("<th class=\"text-center\">" + peso + "</th>");
		stb.append("</tr>");
		stb.append("</thead>");
		stb.append("<tbody>");

		for (int i = 0; i < bobinas.size(); i++) {
			stb.append("<tr>");
			stb.append("<td align='center'>" + bobinas.get(i).getAnchura()
					+ "</td>");
			stb.append("<td align='center'>" + bobinas.get(i).getDiametroExt()
					+ "</td>");
			stb.append("<td align='center'>" + bobinas.get(i).getPeso()
					+ "</td>");
			stb.append("</tr>");
		}
		stb.append("</tbody>");
		stb.append("</table>");

	}

	public static void pintarEstibas(PrintWriter stb, String tituloTEstibas,
			String path, Locale localeNav, List<Estiba> estibas,
			boolean mostrarGraficos) {
		stb.append("<table border='1' width='100%'>");
		stb.append("<thead>");
		stb.append("<tr>");
		stb.append("<th colspan='3' class=\"text-center\">" + tituloTEstibas
				+ "</th>");
		stb.append("</tr>");
		stb.append("</thead>");
		stb.append("<tbody>");
		for (int i = 0; i < estibas.size(); i++) {
			String textoEstibas = (localeNav.equals(Constantes.LOCALE_EU)) ? estibas
					.get(i).getDescEu() : estibas.get(i).getDescEs();
			String imagenEstibas = (localeNav.equals(Constantes.LOCALE_EU)) ? estibas
					.get(i).getImagenEu() : estibas.get(i).getImagenEs();

			stb.append("<tr>");
			if (mostrarGraficos) {
				stb.append("<td valign='top' align='center' colspan='2' height='50'>"
						+ textoEstibas + "</td>");
				stb.append("<td>");
				stb.append("<img src='" + path + imagenEstibas + "&"
						+ Constantes.PORTAL_NOPORTAL + "' width='80'/>");
				stb.append("</td>");
			} else {
				stb.append("<td valign='top' align='center' colspan='3' height='50'>"
						+ textoEstibas + "</td>");
			}
			stb.append("</tr>");
		}

		stb.append("</tbody>");
		stb.append("</table>");

	}

	public static void pintaRecomendacion(PrintWriter stb,
			String textoRecomendacion, String caracteristicasfisicas,
			String diametroExtAbr, String diametroIntAbr, String anchuraAbr,
			String pesoydimensiones, String pesoAbr, String pesominmax,
			String diametroextminmax, String diametrointminmax,
			String anchuraminmax, String path, boolean mostrarGraficos) {

		// RECOMENDACIONES
		stb.append("<tr>");
		stb.append("<td colspan='3'>" + textoRecomendacion + "</td>");
		stb.append("<td></td>");
		stb.append("<td></td>");
		stb.append("</tr>");
		// FIN RECOMENDACIONES

		// LINEA EN BLANCO
		HelpperHtml.pintaSaltoDeLinea(stb);
		// FIN LINEA EN BLANCO

		// RECOMENDACIONES
		stb.append("<tr>");
		stb.append("<td colspan='3'><b>" + caracteristicasfisicas + "</b></td>");
		stb.append("<td></td>");
		stb.append("<td></td>");
		stb.append("</tr>");
		// FIN RECOMENDACIONES
		// CARACTERISTICAS DE LA BOBINA
		stb.append("<tr>");
		stb.append("<td colspan='5'>" + diametroExtAbr + "</td>");
		stb.append("</tr>");
		// stb.append("<tr>");
		// stb.append("<td colspan='5'>" + diametroIntAbr + "</td>");
		// stb.append("</tr>");
		stb.append("<tr>");
		stb.append("<td colspan='5'>" + anchuraAbr + "</td>");
		stb.append("</tr>");
		stb.append("<tr>");
		stb.append("<td colspan='5'>" + pesoAbr + "</td>");
		stb.append("</tr>");
		stb.append("<tr>");
		stb.append("<td colspan='5'></td>");
		stb.append("</tr>");
		stb.append("<tr>");
		stb.append("<td colspan='5'>" + diametroIntAbr + "</td>");
		stb.append("</tr>");
		// FIN RECOMENDACIONES

		// IMAGEN RECOMENDACION
		stb.append("<tr>");
		stb.append("<td>");
		/*
		 * stb.append("<img src='" + rutaDatos +
		 * "/aa94a/images/recomendacion2.png" + "'width='150'/>");
		 */
		if (mostrarGraficos) {
			stb.append("<img src='".concat(path)
					.concat(Constantes.IMG_RECOMENDACION).concat("&")
					.concat(Constantes.PORTAL_NOPORTAL)
					.concat("'width='150'/>"));
		}
		stb.append("</td>");
		stb.append("<td colspan='4'></td>");
		stb.append("</tr>");
		// FIN IMAGEN RECOMENDACION

		// ENTRADA MEDIDAS DE LA BOBINA
		stb.append("<tr>");
		stb.append("<td colspan='3'><b>" + pesoydimensiones + "</b></td>");
		stb.append("<td></td>");
		stb.append("<td></td>");
		stb.append("</tr>");
		// FIN ENTRADA MEDIDAS BOBINA

		// DIMENSIONES DE LA BOBINA
		stb.append("<tr>");
		stb.append("<td colspan='5'>" + pesominmax + "</td>");
		stb.append("</tr>");
		stb.append("<tr>");
		stb.append("<td colspan='5'>" + diametroextminmax + "</td>");
		stb.append("</tr>");
		// stb.append("<tr>");
		// stb.append("<td colspan='5'>" + diametrointminmax + "</td>");
		// stb.append("</tr>");
		stb.append("<tr>");
		stb.append("<td colspan='5'>" + anchuraminmax + "</td>");
		stb.append("</tr>");
		// FIN RECOMENDACIONES
	}

}
